//LidHolesUSB.scad;

//All walls are the same height;

//This module defines the holes for 
//the USB power connectors in 
//the lid of a case;

include <BATT_Dimensions.scad>

module LidHolesUSB()
{

echo("Begin LidHolesUSB");

//I want to echo the distance between 
//the bottom of the USBinput hole and 
//the edge of the lid;
//It should be 17mm;
//The edge of the lid is on the XY plane;
//I just need the height of the bottom 
//of the USBinput hole above that plane;
//It should be:
USBinputDist = USBinputDeltaZ - USBinputZ/2;
echo("USBinputDist = ", USBinputDist);
    
translate([USBinputDeltaX, 
    USBinputDeltaY, USBinputDeltaZ])
cube([USBinputX, USBinputY, USBinputZ], 
    center=true);

//I want to echo the distance between 
//the bottom of the USBoutput hole and 
//the edge of the lid;
//It should be between 18mm and 19mm,
//certainly not near 15mm or 22mm;
//The edge of the lid is on the XY plane;
//I just need the height of the bottom 
//of the USBoutput hole above that plane;
//It should be:
USBoutputDist = USBoutputDeltaZ - USBoutputZ/2;
echo("USBoutputDist = ", USBoutputDist);
    
translate([USBoutputDeltaX, 
    USBoutputDeltaY, USBoutputDeltaZ])
cube([USBoutputX, USBoutputY, USBoutputZ], 
    center=true);

}
//
